/*:
 * @target MZ
 * @plugindesc Backlog Safe-OK Guard v1.0.0 — バックログ表示中は文章送り入力を無効化し、ボイスだけ再生
 * @author Human/ChatGPT
 * @help
 * 使い方：HS_BacklogCore_Simple.js の後に配置してください。
 * バックログ開いている間、Window_Messageの「決定/タッチ進行」を無効化します。
 * さらにバックログ内でOK実行後に入力バッファをクリアして、裏の文章送りを防ぎます。
 */

(() => {
  'use strict';
  const HSBL = window.HSBL || {};
  const isOpen = () => HSBL && typeof HSBL.isOpen === 'function' && HSBL.isOpen();

  // 文章送りのトリガ無効化（バックログ表示中のみ）
  const _WM_isTriggered = Window_Message.prototype.isTriggered;
  Window_Message.prototype.isTriggered = function() {
    if (isOpen()) return false;
    return _WM_isTriggered.apply(this, arguments);
  };

  // タッチでの早送りや各種入力経路の保険
  const _WM_processInput = Window_Message.prototype.processInput;
  Window_Message.prototype.processInput = function() {
    if (isOpen()) return false;
    return _WM_processInput.apply(this, arguments);
  };

  // バックログ内のOK後は入力バッファを掃除（残留OKが裏へ届くのを防ぐ）
  if (window.Window_HS_BacklogList) {
    const _onOk = Window_HS_BacklogList.prototype.onOk;
    Window_HS_BacklogList.prototype.onOk = function() {
      _onOk.apply(this, arguments);
      if (Input.clear) Input.clear();
      if (TouchInput.clear) TouchInput.clear();
      this.activate(); // セレクト継続
    };
    const _onCancel = Window_HS_BacklogList.prototype.onCancel;
    Window_HS_BacklogList.prototype.onCancel = function() {
      if (Input.clear) Input.clear();
      if (TouchInput.clear) TouchInput.clear();
      _onCancel.apply(this, arguments);
    };
  }
})();
